
# import pandas as pd
# import matplotlib.pyplot as plt
# import seaborn as sns
# import os

# plt.rcParams['font.family'] = 'Times New Roman'

# files = {
#     #!!! When swaping MUCAC Be careful only swap it 
    
#     # "CIFAR10_AllCNN": r"C:/Temp/Unlearning/Results/Cifar 10 AllCNN/compiled_results_MIAU.csv",
#     # "CIFAR10_ResNet": r"C:/Temp/Unlearning/Results/Cifar 10 Resnet/compiled_results_MIAU.csv",
#     # "CIFAR20_AllCNN": r"C:/Temp/Unlearning/Results/Cifar 20 AllCNN/compiled_results_MIAU.csv",
#     # "CIFAR20_ResNet": r"C:/Temp/Unlearning/Results/Cifar 20 Resnet/compiled_results_MIAU.csv",
#     # "CIFAR10_ViT": r"C:/Temp/Unlearning/Results/Cifar 10 ViT/compiled_results_MIAU.csv",
#     # "MNIST_ResNet": r"C:/Temp/Unlearning/Results/MNIST Resnet/compiled_results_MIAU.csv",
#     # "MNIST_AllCNN": r"C:/Temp/Unlearning/Results/MNIST AllCNN/compiled_results_MIAU.csv",
#     # "MUCAC_ResNet": r"C:/Temp/Unlearning/Results/MUCAC Resnet/compiled_results_MIAU.csv"
    
    
    # "CIFAR10_ResNet_Underfitted": r"C:/Temp/Unlearning/Results/Underfitted/compiled_results_MIAU.csv",
    # "CIFAR10_ResNet_Overfitted": r"C:/Temp/Unlearning/Results/Overfitted/compiled_results_MIAU.csv"
# }
# methods = ['retrain25', 'retrain50', 'retrain75']
# label_map = {'retrain25': '25%', 'retrain50': '50%', 'retrain75': '75%'}

# plot_data = []

# for name, path in files.items():
#     try:
#         df = pd.read_csv(path)
#         df_filtered = df[df['unlearning'].isin(methods)]
#         grouped = df_filtered.groupby('unlearning')['MIAU'].agg(['mean', 'std']).reset_index()
#         for _, row in grouped.iterrows():
#             plot_data.append({
#                 "Dataset": name,
#                 "Retrain %": label_map[row['unlearning']],
#                 "Average MIAU": row['mean'],
#                 "Std MIAU": row['std']
#             })
#     except Exception as e:
#         print(f"Error processing {name}: {e}")

# df_plot = pd.DataFrame(plot_data)

# plt.figure(figsize=(12, 6))
# sns.set(style="whitegrid", font_scale=1.2)

# ax = sns.barplot(
#     data=df_plot,
#     x="Retrain %",
#     y="Average MIAU",
#     hue="Dataset",
#     ci=None,
#     capsize=0.1
# )

# retrain_levels = ["25%", "50%", "75%"]
# datasets = df_plot["Dataset"].unique()
# n_datasets = len(datasets)
# bar_width = 0.8 / n_datasets  

# for j, retrain_label in enumerate(retrain_levels): 
#     for i, dataset in enumerate(datasets): 
#         subset = df_plot[(df_plot['Dataset'] == dataset) & (df_plot['Retrain %'] == retrain_label)]
#         if not subset.empty:
#             avg = subset['Average MIAU'].values[0]
#             std = subset['Std MIAU'].values[0]
#             x_center = j + (i + 0.5 - n_datasets / 2) * bar_width
#             ax.errorbar(x_center, avg, yerr=std, fmt='none', c='black', capsize=4, linewidth=1.5)

# plt.title("Average MIAU Score ± Std Across Seeds", fontname='Times New Roman')
# plt.ylabel("Average MIAU", fontname='Times New Roman')
# plt.xlabel("Retraining Level", fontname='Times New Roman')
# plt.legend(title="Experiment", bbox_to_anchor=(0.5, -0.25), loc='upper center', ncol=3)
# plt.tight_layout()

# plt.savefig(r"C:/Temp/Unlearning/figure_bargraph_retrains_nongeneralized.pdf", dpi=300, bbox_inches='tight')
# plt.show()





import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np

plt.rcParams['font.family'] = 'Times New Roman'

files = {
    #     "CIFAR10_ResNet_Underfitted": r"C:/Temp/Unlearning/Data Appendix/Underfitted/compiled_results_MIAU.csv",
    # "CIFAR10_ResNet_Overfitted": r"C:/Temp/Unlearning/Data Appendix/Overfitted/compiled_results_MIAU.csv"
    
      "CIFAR10_AllCNN": r"C:/Temp/Unlearning/Data Appendix/Cifar 10 AllCNN/compiled_results_MIAU.csv",
    "CIFAR10_ResNet": r"C:/Temp/Unlearning/Data Appendix/Cifar 10 Resnet/compiled_results_MIAU.csv",
    
        "CIFAR10_ResNet_Saliency": r"C:\Temp\Unlearning\Data Appendix\Cifar 10 Resnet Saliency\compiled_results_MIAU.csv",


    "CIFAR20_AllCNN": r"C:/Temp/Unlearning/Data Appendix/Cifar 20 AllCNN/compiled_results_MIAU.csv",
      "CIFAR20_AllCNN_SubClass": r"C:\Temp\Unlearning\Data Appendix\Cifar 20 AllCNN SubClass\compiled_results_MIAU.csv",
    "CIFAR20_AllCNN_FullClass": r"C:\Temp\Unlearning\Data Appendix\Cifar 20 AllCNN FullClass\compiled_results_MIAU.csv",
    
    "CIFAR20_ResNet": r"C:/Temp/Unlearning/Data Appendix/Cifar 20 Resnet/compiled_results_MIAU.csv",
    "CIFAR10_ViT": r"C:/Temp/Unlearning/Data Appendix/Cifar 10 ViT/compiled_results_MIAU.csv",
    "MNIST_ResNet": r"C:/Temp/Unlearning/Data Appendix/MNIST Resnet/compiled_results_MIAU.csv",
    "MNIST_AllCNN": r"C:/Temp/Unlearning/Data Appendix/MNIST AllCNN/compiled_results_MIAU.csv",
    "MUCAC_ResNet": r"C:/Temp/Unlearning/Data Appendix/MUCAC Resnet/compiled_results_MIAU.csv"
    
}

methods = ['retrain25', 'retrain50', 'retrain75']
label_map = {'retrain25': '25%', 'retrain50': '50%', 'retrain75': '75%'}
retrain_levels = ["25%", "50%", "75%"]

plot_rows = []
METRIC_MIN = 0.0     # clip lower end here
METRIC_MAX = 100.0   # and upper end here (your MIAU is 0..100)

# --- load & aggregate ---
for name, path in files.items():
    try:
        df = pd.read_csv(path)
        df_filtered = df[df['unlearning'].isin(methods)].copy()
        if df_filtered.empty:
            print(f"[WARN] No rows after filtering methods in: {name}")
            continue

        grouped = (df_filtered
                   .groupby('unlearning', as_index=False)['MIAU']
                   .agg(mean='mean', std='std'))

        for _, row in grouped.iterrows():
            method = row['unlearning']
            avg = float(row['mean'])
            std = float(row['std']) if pd.notna(row['std']) else 0.0
            plot_rows.append({
                "Dataset": name,
                "Retrain %": label_map.get(method, method),
                "Average MIAU": avg,
                "Std MIAU": max(std, 0.0),
            })
    except Exception as e:
        print(f"[ERROR] {name}: {e}")

df_plot = pd.DataFrame(plot_rows)

df_plot["Retrain %"] = pd.Categorical(df_plot["Retrain %"],
                                      categories=retrain_levels, ordered=True)
datasets_order = sorted(df_plot["Dataset"].unique().tolist())
df_plot["Dataset"] = pd.Categorical(df_plot["Dataset"],
                                    categories=datasets_order, ordered=True)

if df_plot.empty:
    raise RuntimeError("No data to plot. Check file paths and CSV contents.")

# --- plot ---
plt.figure(figsize=(12, 6))
sns.set(style="whitegrid", font_scale=1.2)
palette = sns.color_palette("tab20", n_colors=len(datasets_order))

ax = sns.barplot(
    data=df_plot,
    x="Retrain %",
    y="Average MIAU",
    hue="Dataset",
    ci=None,
    dodge=True,
     palette=palette    
)

n_datasets = len(datasets_order)
bar_width = 0.8 / n_datasets

# fast lookup
lookup = {
    (r["Dataset"], r["Retrain %"]): (float(r["Average MIAU"]), float(r["Std MIAU"]))
    for _, r in df_plot.iterrows()
}

for j, retrain_label in enumerate(retrain_levels):
    for i, dataset in enumerate(datasets_order):
        key = (dataset, retrain_label)
        if key not in lookup:
            continue

        avg, std = lookup[key]

        # ---- CLIPPED ASYMMETRIC ERRORS ----
        # lower may not go below METRIC_MIN; upper may not go above METRIC_MAX
        lower_err = min(std, max(avg - METRIC_MIN, 0.0))
        upper_err = min(std, max(METRIC_MAX - avg, 0.0))
        yerr = np.array([[lower_err], [upper_err]])

        # x-position aligned with dodged bars
        x_center = j + (i + 0.5 - n_datasets / 2) * bar_width

        ax.errorbar(
            x_center, avg,
            yerr=yerr,
            fmt='none',
            ecolor='black',
            capsize=4,
            linewidth=1.5,
            clip_on=True,    # ensure anything outside axes is not drawn
            zorder=3
        )

#axes & labels
ax.set_title("Average MIAU Score ± Std Across Seeds", fontname='Times New Roman')
ax.set_xlabel("Retraining Level", fontname='Times New Roman')
ax.set_ylabel("Average MIAU", fontname='Times New Roman')
ax.set_ylim(METRIC_MIN, METRIC_MAX)   # hard clamp to [0, 100]

ax.legend(title="Experiment", bbox_to_anchor=(0.5, -0.25),
          loc='upper center', ncol=3)

plt.tight_layout()
plt.savefig(r"C:/Temp/Unlearning/figure_bargraph_retrains.pdf",
            dpi=300, bbox_inches='tight')
plt.show()




